<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<title>IBSheet7-Product</title>

	<script type="text/javascript" src="../js/common.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts-more.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/funnel.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/boost.js"></script>
	<script type="text/javascript" src="../Chart/ibchart.js"></script>
	<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
	<script type="text/javascript" src="./chartTypeOptions.js"></script>

<script type="text/javascript" src="https://unpkg.com/canvg@3.0.4/lib/umd.js"></script>

	<script type="text/javascript">
		$(document).ready(function () {
			createIBChart("lineChart", "lineChart", {
				width: "100%",
				height: "85%"
			});

			lineChartDraw();
		});

		function lineChartDraw() {
			var Type = $("#lineCombo").val();
			lineChart.removeAll();
			lineChart.setOptions(lineChartOption); //라인차트 기본값 설정 (chartTypeOptions.js)
			switch (Type) {
				case "LINE_Marker": //선형차트 기본
					break;

				case "LINE_Stacking_Normal_Marker": //선형차트 누적
					lineChart.setOptions({
						plotOptions: {
							series: {
								stacking: "normal"
							}
						}
					}, {
						append: true
					});
					break;

				case "LINE_Stacking_Marker": //선형차트 100% 누적
					lineChart.setOptions({
						plotOptions: {
							series: {
								stacking: "percent"
							}
						}
					}, {
						append: true
					});
					break;

				case "SPLINE_Marker": //부드러운 선형 차트
					lineChart.setOptions({
						chart: {
							type: "spline"
						}
					}, {
						append: true
					});
					break;

				case "SCATTER": //산점 차트
					lineChart.setOptions({
						chart: {
							type: "scatter",
							zoomType: "xy"
						}
					}, {
						append: true
					});

					doSearch(lineChart, "chartdata_scatter.json");
					break;

				case "BUBBLE": //버블(거품) 차트
					lineChart.setOptions({
						chart: {
							type: "bubble",
							zoomType: "xy"
						}
					}, {
						append: true
					});

					doSearch(lineChart, "chartdata_bubble.json");
					break;

				case "LINE_Step_Marker": //계단형 차트
					lineChart.setOptions({
						plotOptions: {
							line: {
								step: true
							}
						}
					}, {
						append: true
					});
					break;
				case "AREA": //영역 차트
					lineChart.setOptions({
						chart: {
							type: "area"
						}
					}, {
						append: true
					});
					break;

				case "AREA_Stacking_Normal": //영역 누적 차트
					lineChart.setOptions({
						chart: {
							type: "area"
						},
						plotOptions: {
							series: {
								stacking: "normal"
							}
						}
					}, {
						append: true
					});
					break;

				case "AREA_Stacking": //영역 누적 100%
					lineChart.setOptions({
						chart: {
							type: "area"
						},
						plotOptions: {
							series: {
								stacking: "percent"
							}
						}
					}, {
						append: true
					});
					break;

				case "AREASPLINE": //부드러운 영역 형
					lineChart.setOptions({
						chart: {
							type: "areaspline"
						}
					}, {
						append: true
					});
					break;
			}
			//데이터 조회
			if (Type != "SCATTER" && Type != "BUBBLE") {
				doSearch(lineChart, "chartdata.json");
			}
		}

		function Down2Image(Type) {
			switch (Type) {
				case "PNG":
					//chart객체, 파일명
					downChart2Image(lineChart,"선형차트.png");
					break;

			}
		}

		function doSearch(chart, url, subparam) {
			$.ajax({
				type: 'post',
				async: true,
				dataType: "text",
				url: url,
				data: subparam,
				beforeSend: function () {

				},
				success: function (JSON) {
					chart.loadSearchData(JSON, {
						append: true
					});
				},
				error: function (data, status, err) {
					alert('서버와의 통신이 실패했습니다.');
				},
				complete: function (jqXHR, textStatus) {

				}
			});
		}

		function DoPrint() {
			lineChart.doPrint();
		}
	</script>
</head>

<body>
	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트 유형 > <b>선형 차트</b></span>
	</div>
	<div class="main_content">
		<div style="float:left;width:100%">
			<div class="exp_product" style="float:left;width:30%">
				선형 차트를 확인합니다.
			</div>
			<div class="ib_function" style="float:left;width:70%;text-align:right">
				<a href="javascript:Down2Image('PNG')" class="f1_btn_white gray">이미지 다운로드</a>
				<a href="javascript:DoPrint()" class="f1_btn_white gray">이미지 프린트</a>
			</div>
		</div>
		<div class="clear hidden"></div>
		<p class="subtit_chart">차트 유형</p>
		<div class="ib_chart_product">
			차트종류 : <select class="chartCombo" id="lineCombo" onchange="lineChartDraw()">
				<option value="LINE_Marker">꺽은선</option>
				<option value="LINE_Stacking_Normal_Marker">누적 꺽은선</option>
				<option value="LINE_Stacking_Marker">100% 누적 꺽은선</option>
				<option value="SPLINE_Marker" selected>심볼 부드러운선</option>
				<option value="LINE_Step_Marker">심볼 계단</option>
				<option value="AREA">영역</option>
				<option value="AREA_Stacking_Normal">누적 영역</option>
				<option value="AREA_Stacking">100% 누적 영역</option>
				<option value="AREASPLINE">부드러운 영역</option>
			</select>
			<div style="height:10px"></div>
			<div id="lineChart"></div>
		</div>
		<!--main_content-->
</body>

</html>